/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.tileentity;

import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.container.CraftingCoreContainer;
import com.blakebr0.extendedcrafting.crafting.recipe.CombinationRecipe;
import com.blakebr0.extendedcrafting.init.ModTileEntities;
import com.blakebr0.extendedcrafting.tileentity.PedestalTileEntity;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class CraftingCoreTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory = CraftingCoreTileEntity.createInventoryHandler(() -> ((CraftingCoreTileEntity)this).markDirtyAndDispatch());
    private final EnergyStorage energy = new EnergyStorage(((Integer)ModConfigs.CRAFTING_CORE_POWER_CAPACITY.get()).intValue());
    private final BaseItemStackHandler recipeInventory = new BaseItemStackHandler(49);
    private CombinationRecipe recipe;
    private int progress;
    private int oldEnergy;
    private int pedestalCount;
    private boolean haveItemsChanged = true;

    public CraftingCoreTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.CRAFTING_CORE.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, LazyOptional.of(this::getEnergy));
        }
        return super.getCapability(cap, side);
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.extendedcrafting.crafting_core").build();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return CraftingCoreContainer.create(windowId, playerInventory, arg_0 -> ((CraftingCoreTileEntity)this).isUsableByPlayer(arg_0), (ContainerData)new SimpleContainerData(0), this.m_58899_());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, CraftingCoreTileEntity tile) {
        boolean mark = false;
        Map<BlockPos, ItemStack> pedestalsWithItems = tile.getPedestalsWithItems();
        ItemStack[] stacks = pedestalsWithItems.values().toArray(new ItemStack[0]);
        tile.updateRecipeInventory(stacks);
        if (tile.haveItemsChanged && (tile.recipe == null || !tile.recipe.matches((IItemHandler)tile.recipeInventory))) {
            tile.recipe = level.m_7465_().m_44015_(RecipeTypes.COMBINATION, tile.recipeInventory.toIInventory(), level).orElse(null);
        }
        if (!level.m_5776_()) {
            if (tile.recipe != null) {
                if (tile.energy.getEnergyStored() > 0) {
                    boolean done = tile.process(tile.recipe);
                    if (done) {
                        for (BlockPos pedestalPos : pedestalsWithItems.keySet()) {
                            BlockEntity pedestalTile = level.m_7702_(pedestalPos);
                            if (!(pedestalTile instanceof PedestalTileEntity)) continue;
                            PedestalTileEntity pedestal = (PedestalTileEntity)pedestalTile;
                            BaseItemStackHandler inventory = pedestal.getInventory();
                            inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)inventory.getStackInSlot(0), (int)1, (boolean)true));
                            pedestal.markDirtyAndDispatch();
                            tile.spawnParticles(ParticleTypes.f_123762_, pedestalPos, 1.1, 20);
                        }
                        tile.spawnParticles(ParticleTypes.f_123810_, pos, 1.1, 50);
                        tile.inventory.setStackInSlot(0, tile.recipe.assemble((IItemHandler)tile.recipeInventory));
                        tile.progress = 0;
                        mark = true;
                    } else {
                        tile.spawnParticles(ParticleTypes.f_123811_, pos, 1.15, 2);
                        if (tile.shouldSpawnItemParticles()) {
                            for (BlockPos pedestalPos : pedestalsWithItems.keySet()) {
                                BlockEntity pedestalTile = level.m_7702_(pedestalPos);
                                if (!(pedestalTile instanceof PedestalTileEntity)) continue;
                                PedestalTileEntity pedestal = (PedestalTileEntity)pedestalTile;
                                BaseItemStackHandler inventory = pedestal.getInventory();
                                ItemStack stack = inventory.getStackInSlot(0);
                                tile.spawnItemParticles(pedestalPos, stack);
                            }
                        }
                    }
                }
            } else {
                tile.progress = 0;
            }
        }
        if (tile.oldEnergy != tile.energy.getEnergyStored()) {
            tile.oldEnergy = tile.energy.getEnergyStored();
            if (!mark) {
                mark = true;
            }
        }
        if (mark) {
            tile.markDirtyAndDispatch();
        }
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        BaseItemStackHandler inventory = new BaseItemStackHandler(1, onContentsChanged);
        inventory.setDefaultSlotLimit(1);
        return inventory;
    }

    public EnergyStorage getEnergy() {
        return this.energy;
    }

    public CombinationRecipe getActiveRecipe() {
        return this.recipe;
    }

    public boolean hasRecipe() {
        return this.recipe != null;
    }

    public int getEnergyRequired() {
        return this.hasRecipe() ? this.recipe.getPowerCost() : 0;
    }

    public int getEnergyRate() {
        return this.hasRecipe() ? this.recipe.getPowerRate() : 0;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getPedestalCount() {
        return this.pedestalCount;
    }

    private void updateRecipeInventory(ItemStack[] items) {
        int i;
        boolean haveItemsChanged;
        boolean bl = haveItemsChanged = this.recipeInventory.getSlots() != items.length + 1 || !StackHelper.areStacksEqual((ItemStack)this.recipeInventory.getStackInSlot(0), (ItemStack)this.inventory.getStackInSlot(0));
        if (!haveItemsChanged) {
            for (i = 0; i < items.length; ++i) {
                if (StackHelper.areStacksEqual((ItemStack)this.recipeInventory.getStackInSlot(i + 1), (ItemStack)items[i])) continue;
                haveItemsChanged = true;
                break;
            }
        }
        this.haveItemsChanged = haveItemsChanged;
        if (!haveItemsChanged) {
            return;
        }
        this.recipeInventory.setSize(items.length + 1);
        this.recipeInventory.setStackInSlot(0, this.inventory.getStackInSlot(0));
        for (i = 0; i < items.length; ++i) {
            this.recipeInventory.setStackInSlot(i + 1, items[i]);
        }
    }

    private boolean process(CombinationRecipe recipe) {
        int extract = recipe.getPowerRate();
        int difference = recipe.getPowerCost() - this.progress;
        if (difference < recipe.getPowerRate()) {
            extract = difference;
        }
        int extracted = this.energy.extractEnergy(extract, false);
        this.progress += extracted;
        return this.progress >= recipe.getPowerCost();
    }

    public Map<BlockPos, ItemStack> getPedestalsWithItems() {
        HashMap<BlockPos, ItemStack> pedestals = new HashMap<BlockPos, ItemStack>();
        Level world = this.m_58904_();
        int pedestalCount = 0;
        if (world != null) {
            BlockPos pos = this.m_58899_();
            Iterator positions = BlockPos.m_121990_((BlockPos)pos.m_142082_(-3, 0, -3), (BlockPos)pos.m_142082_(3, 0, 3)).iterator();
            while (positions.hasNext()) {
                BlockPos aoePos = (BlockPos)positions.next();
                BlockEntity tile = world.m_7702_(aoePos);
                if (!(tile instanceof PedestalTileEntity)) continue;
                PedestalTileEntity pedestal = (PedestalTileEntity)tile;
                ItemStack stack = pedestal.getInventory().getStackInSlot(0);
                ++pedestalCount;
                if (stack.m_41619_()) continue;
                pedestals.put(aoePos.m_7949_(), stack);
            }
        }
        this.pedestalCount = pedestalCount;
        return pedestals;
    }

    private <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_58904_();
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + yOffset;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_8767_(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    private void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_58904_();
        BlockPos pos = this.m_58899_();
        double x = (double)pedestalPos.m_123341_() + level.m_5822_().nextDouble() * 0.2 + 0.4;
        double y = (double)pedestalPos.m_123342_() + level.m_5822_().nextDouble() * 0.2 + 1.4;
        double z = (double)pedestalPos.m_123343_() + level.m_5822_().nextDouble() * 0.2 + 0.4;
        double velX = pos.m_123341_() - pedestalPos.m_123341_();
        double velY = 0.25;
        double velZ = pos.m_123343_() - pedestalPos.m_123343_();
        level.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    private boolean shouldSpawnItemParticles() {
        int powerRate;
        int endingPower;
        int powerCost = this.recipe.getPowerCost();
        return this.progress > powerCost - (endingPower = (powerRate = this.recipe.getPowerRate()) * 40);
    }
}

